/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

// Further adapted by TheEmu by 
//   1) Replacing sets of x,y,z scalars by vectors
//   2) Minimising conditionaly executed code
//   3) Other minor tidyings

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define PI 3.14159265359

const float f3   = 1.0/3.0;
const float g3_1 = 1.0/6.0;
const float g3_2 = 2.0/6.0;
const float g3_3 = 3.0/6.0;

const vec3 K001 = vec3 ( 0.0, 0.0, 1.0 );
const vec3 K010 = vec3 ( 0.0, 1.0, 0.0 );
const vec3 K100 = vec3 ( 1.0, 0.0, 0.0 );

const vec3 K011 = vec3 ( 0.0, 1.0, 1.0 );
const vec3 K101 = vec3 ( 1.0, 0.0, 1.0 );
const vec3 K110 = vec3 ( 1.0, 1.0, 0.0 );

const vec3 kNoise = vec3(12.9898,78.233,128.852);

#define noise3D(p) ( fract ( sin(dot(p,kNoise)) * 43758.5453 ) * 2.0 - 1.0 )

vec3 noise3DX ( vec3 p )
{
  return normalize(vec3(noise3D(p),noise3D(p*2.01),noise3D(p*2.02)));
}

#define VEC3SUM(q) ( q.x + q.y + q.z )

float simplex3D ( vec3 p )
{
   vec3 ijk0 = floor ( p + VEC3SUM(p)*f3 );
   vec3 xyz0 = p - ijk0 + VEC3SUM(ijk0)*g3_1;

   vec3 ijk1, ijk2, ijk3;

   bool x_ge_y = (xyz0.x>=xyz0.y);
   bool y_ge_z = (xyz0.y>=xyz0.z);
   bool x_ge_z = (xyz0.x>=xyz0.z);

   if ( x_ge_y )
   {
     ijk1=K100; ijk2=K101;               // X Z Y order
     if      (   y_ge_z ) { ijk2=K110; } // X Y Z order
     else if ( ! x_ge_z ) { ijk1=K001; } // Z X Z order
   }
   else 
   {
     ijk1=K010; ijk2=K011;               // Y Z X order
     if      ( ! y_ge_z ) { ijk1=K001; } // Z Y X order
     else if (   x_ge_z ) { ijk2=K110; } // Y X Z order
   }

   vec3 xyz1 = xyz0 - ijk1 + g3_1;
   vec3 xyz2 = xyz0 - ijk2 + g3_2;
   vec3 xyz3 = xyz0 - 1.00 + g3_3;

   float t0 = max ( 0.0, 0.5 - dot(xyz0,xyz0) );
   float t1 = max ( 0.0, 0.5 - dot(xyz1,xyz1) );
   float t2 = max ( 0.0, 0.5 - dot(xyz2,xyz2) );
   float t3 = max ( 0.0, 0.5 - dot(xyz3,xyz3) );

   float nn = 0.0;

   t0*=t0; nn += t0 * t0 * dot( xyz0, noise3DX(ijk0)        );
   t1*=t1; nn += t1 * t1 * dot( xyz1, noise3DX(ijk0 + ijk1) );
   t2*=t2; nn += t2 * t2 * dot( xyz2, noise3DX(ijk0 + ijk2) );
   t3*=t3; nn += t3 * t3 * dot( xyz3, noise3DX(ijk0 + 1.00) );

   return 96.0 * nn;

}

float fbm(vec3 p)
{
   float f;
   f  = 0.50000*simplex3D( p ); p = p*2.01;
   f += 0.25000*simplex3D( p ); p = p*2.02; //from iq
   f += 0.12500*simplex3D( p ); p = p*2.03;
   f += 0.06250*simplex3D( p ); p = p*2.04;
   f += 0.03125*simplex3D( p );
   return f;
}

// function rot deleted as it was not used - TheEmu

void main ( void )
{
   float time = iGlobalTime*0.25;

   vec2 uv = gl_FragCoord.xy/iResolution.xy;

   vec2 p = uv*2.0-1.0;

   p.x*=1.78;
   p.x*=uv.y*uv.y+2.0;
   p.x*=pow(uv.y,10.0*uv.y)+0.8;
   p.y-=1.0;

   uv.y-=0.2;

   p.x+=fbm(vec3(time*0.1,uv)*0.5)*0.5;

   vec3 ro = vec3(0.0,-time*4.0,-2.0);
   vec3 rd = normalize(vec3(p.x,p.y-time*4.0,0.0)-ro);
   vec3 lp = vec3(0.0,-time*4.0-1.5,0.0);
   vec3 col = vec3(0.02,0.005,0.001);

   if(length(p)<2.5) // don't waste resources on pixels that are behind the mask
   {
     for(int i = 0; i<5; i++)
     {
       vec3 rp = ro+rd*float(i);
       float c = distance(rp,lp);
       float n = fbm(rp)*0.5+0.5;
       col = col*(10.0*n/c)*(fbm(vec3(time*0.1))*0.5+1.0);
     }
   } 

   //some color masks with fbm

   col*=smoothstep(1.0,-1.0,uv.y-smoothstep(0.0,1.0,fbm(vec3(p.x,uv.y*1.0-time*2.0,time)*1.0)*2.0));
   col*=smoothstep(1.0,-1.0,uv.y-smoothstep(0.0,1.0,fbm(vec3(p.x+100.0,uv.y*1.0-time*1.5,time)*2.0)*2.0));
   col*=smoothstep(1.0,-1.0,uv.y-smoothstep(0.0,4.0,fbm(vec3(p.x+200.0,uv.y*1.0-time*1.0,time)*2.0)*2.0));

   col*=smoothstep(2.5,0.0,length(p)); //mask the edges
   col*=vec3(1.0,1.0,100.0*smoothstep(0.0,-1.0,uv.y-p.x*p.x*0.1)); //blue hue bottom
   col*=1.0+smoothstep(0.5,0.2,length((uv*2.0-1.0)*vec2(.75,1.0)+vec2(0.0,1.2)))*2.0; //stronger base for the flame

   col = clamp(col, 0.0,1.0);

   gl_FragColor = vec4(col,1.0);

}
